/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RDocumentCharSequence;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RegExReplaceInfo;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchResult;

public class SearchEngine {
    private SearchEngine() {
    }

    public static SearchResult find(JTextArea textArea, SearchContext context) {
        SearchResult result2;
        if (textArea instanceof RTextArea || context.getMarkAll()) {
            ((RTextArea)textArea).clearMarkAllHighlights();
        }
        boolean doMarkAll = textArea instanceof RTextArea && context.getMarkAll();
        String text2 = context.getSearchFor();
        if (text2 == null || text2.length() == 0) {
            if (doMarkAll) {
                List<DocumentRange> emptyRangeList = Collections.emptyList();
                ((RTextArea)textArea).markAll(emptyRangeList);
            }
            return new SearchResult();
        }
        Caret c = textArea.getCaret();
        boolean forward = context.getSearchForward();
        int start = forward ? Math.max(c.getDot(), c.getMark()) : Math.min(c.getDot(), c.getMark());
        String findIn2 = SearchEngine.getFindInText(textArea, start, forward);
        if (findIn2 == null || findIn2.length() == 0) {
            return new SearchResult();
        }
        int markAllCount = 0;
        if (doMarkAll) {
            markAllCount = SearchEngine.markAllImpl((RTextArea)textArea, context).getMarkedCount();
        }
        if ((result2 = SearchEngine.findImpl(findIn2, context)).wasFound() && !result2.getMatchRange().isZeroLength()) {
            textArea.getCaret().setSelectionVisible(true);
            if (forward && start > -1) {
                result2.getMatchRange().translate(start);
            }
            SearchEngine.selectAndPossiblyCenter(textArea, result2.getMatchRange(), true);
        }
        result2.setMarkedCount(markAllCount);
        return result2;
    }

    private static SearchResult findImpl(String findIn2, SearchContext context) {
        String text2 = context.getSearchFor();
        boolean forward = context.getSearchForward();
        DocumentRange range2 = null;
        if (!context.isRegularExpression()) {
            int pos = SearchEngine.getNextMatchPos(text2, findIn2, forward, context.getMatchCase(), context.getWholeWord());
            findIn2 = null;
            if (pos != -1) {
                range2 = new DocumentRange(pos, pos + text2.length());
            }
        } else {
            Point regExPos = null;
            int start = 0;
            do {
                if ((regExPos = SearchEngine.getNextMatchPosRegEx(text2, findIn2.substring(start), forward, context.getMatchCase(), context.getWholeWord())) == null) continue;
                if (regExPos.x != regExPos.y) {
                    regExPos.translate(start, start);
                    range2 = new DocumentRange(regExPos.x, regExPos.y);
                    continue;
                }
                start += regExPos.x + 1;
            } while (start < findIn2.length() && regExPos != null && range2 == null);
        }
        if (range2 != null) {
            return new SearchResult(range2, 1, 0);
        }
        return new SearchResult();
    }

    private static CharSequence getFindInCharSequence(RTextArea textArea, int start, boolean forward) {
        RDocument doc = (RDocument)textArea.getDocument();
        int csStart = 0;
        int csEnd = 0;
        if (forward) {
            csStart = start;
            csEnd = doc.getLength();
        } else {
            csStart = 0;
            csEnd = start;
        }
        return new RDocumentCharSequence(doc, csStart, csEnd);
    }

    private static String getFindInText(JTextArea textArea, int start, boolean forward) {
        String findIn2 = null;
        try {
            findIn2 = forward ? textArea.getText(start, textArea.getDocument().getLength() - start) : textArea.getText(0, start);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return findIn2;
    }

    private static List getMatches(Matcher m, String replaceStr) {
        ArrayList<Object> matches = new ArrayList<Object>();
        while (m.find()) {
            Point loc = new Point(m.start(), m.end());
            if (replaceStr == null) {
                matches.add(loc);
                continue;
            }
            matches.add(new RegExReplaceInfo(m.group(0), loc.x, loc.y, SearchEngine.getReplacementText(m, replaceStr)));
        }
        return matches;
    }

    public static final int getNextMatchPos(String searchFor, String searchIn, boolean forward, boolean matchCase, boolean wholeWord) {
        if (!matchCase) {
            return SearchEngine.getNextMatchPosImpl(searchFor.toLowerCase(), searchIn.toLowerCase(), forward, matchCase, wholeWord);
        }
        return SearchEngine.getNextMatchPosImpl(searchFor, searchIn, forward, matchCase, wholeWord);
    }

    private static final int getNextMatchPosImpl(String searchFor, String searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        if (wholeWord) {
            int len = searchFor.length();
            int temp = goForward ? 0 : searchIn.length();
            int tempChange = goForward ? 1 : -1;
            while ((temp = goForward ? searchIn.indexOf(searchFor, temp) : searchIn.lastIndexOf(searchFor, temp)) != -1) {
                if (SearchEngine.isWholeWord(searchIn, temp, len)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return goForward ? searchIn.indexOf(searchFor) : searchIn.lastIndexOf(searchFor);
    }

    private static Point getNextMatchPosRegEx(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        return (Point)SearchEngine.getNextMatchPosRegExImpl(regEx, searchIn, goForward, matchCase, wholeWord, null);
    }

    private static Object getNextMatchPosRegExImpl(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord, String replaceStr) {
        if (wholeWord) {
            regEx = "\\b" + regEx + "\\b";
        }
        int flags = 8;
        flags = RSyntaxUtilities.getPatternFlags(matchCase, flags);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regEx, flags);
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
        Matcher m = pattern.matcher(searchIn);
        if (goForward) {
            if (m.find()) {
                if (replaceStr == null) {
                    return new Point(m.start(), m.end());
                }
                return new RegExReplaceInfo(m.group(0), m.start(), m.end(), SearchEngine.getReplacementText(m, replaceStr));
            }
        } else {
            List matches = SearchEngine.getMatches(m, replaceStr);
            if (!matches.isEmpty()) {
                return matches.get(matches.size() - 1);
            }
        }
        return null;
    }

    private static RegExReplaceInfo getRegExReplaceInfo(CharSequence searchIn, SearchContext context) {
        String replacement = context.getReplaceWith();
        if (replacement == null) {
            replacement = "";
        }
        String regex = context.getSearchFor();
        boolean goForward = context.getSearchForward();
        boolean matchCase = context.getMatchCase();
        boolean wholeWord = context.getWholeWord();
        return (RegExReplaceInfo)SearchEngine.getNextMatchPosRegExImpl(regex, searchIn, goForward, matchCase, wholeWord, replacement);
    }

    public static String getReplacementText(Matcher m, CharSequence template) {
        int cursor = 0;
        StringBuilder result2 = new StringBuilder();
        while (cursor < template.length()) {
            char nextChar = template.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = template.charAt(++cursor);
                switch (nextChar) {
                    case 'n': {
                        nextChar = '\n';
                        break;
                    }
                    case 't': {
                        nextChar = '\t';
                    }
                }
                result2.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                int refNum;
                if ((refNum = template.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IndexOutOfBoundsException("No group " + template.charAt(cursor));
                }
                ++cursor;
                boolean done2 = false;
                while (!done2 && cursor < template.length() && (nextDigit = template.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (m.groupCount() < newRefNum) {
                        done2 = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (m.group(refNum) == null) continue;
                result2.append(m.group(refNum));
                continue;
            }
            result2.append(nextChar);
            ++cursor;
        }
        return result2.toString();
    }

    private static final boolean isWholeWord(CharSequence searchIn, int offset, int len) {
        boolean wsAfter;
        boolean wsBefore;
        try {
            wsBefore = !Character.isLetterOrDigit(searchIn.charAt(offset - 1));
        }
        catch (IndexOutOfBoundsException e) {
            wsBefore = true;
        }
        try {
            wsAfter = !Character.isLetterOrDigit(searchIn.charAt(offset + len));
        }
        catch (IndexOutOfBoundsException e) {
            wsAfter = true;
        }
        return wsBefore && wsAfter;
    }

    private static final int makeMarkAndDotEqual(JTextArea textArea, boolean forward) {
        Caret c = textArea.getCaret();
        int val = forward ? Math.min(c.getDot(), c.getMark()) : Math.max(c.getDot(), c.getMark());
        c.setDot(val);
        return val;
    }

    public static final SearchResult markAll(RTextArea textArea, SearchContext context) {
        textArea.clearMarkAllHighlights();
        return SearchEngine.markAllImpl(textArea, context);
    }

    private static final SearchResult markAllImpl(RTextArea textArea, SearchContext context) {
        String toMark = context.getSearchFor();
        int markAllCount = 0;
        if (context.getMarkAll() && toMark != null && toMark.length() > 0) {
            ArrayList<DocumentRange> highlights = new ArrayList<DocumentRange>();
            context = context.clone();
            context.setSearchForward(true);
            context.setMarkAll(false);
            String findIn2 = textArea.getText();
            int start = 0;
            if (!context.getMatchCase()) {
                context.setMatchCase(true);
                context.setSearchFor(toMark.toLowerCase());
                findIn2 = findIn2.toLowerCase();
            }
            SearchResult res = SearchEngine.findImpl(findIn2, context);
            while (res.wasFound()) {
                DocumentRange match = res.getMatchRange().translate(start);
                if (match.isZeroLength()) {
                    start = match.getEndOffset() + 1;
                    if (start > findIn2.length()) {
                        break;
                    }
                } else {
                    highlights.add(match);
                    start = match.getEndOffset();
                }
                res = SearchEngine.findImpl(findIn2.substring(start), context);
            }
            textArea.markAll(highlights);
            markAllCount = highlights.size();
        } else {
            List<DocumentRange> empty2 = Collections.emptyList();
            textArea.markAll(empty2);
        }
        return new SearchResult(null, 0, markAllCount);
    }

    private static SearchResult regexReplace(RTextArea textArea, SearchContext context) throws PatternSyntaxException {
        Caret c = textArea.getCaret();
        boolean forward = context.getSearchForward();
        int start = SearchEngine.makeMarkAndDotEqual(textArea, forward);
        CharSequence findIn2 = SearchEngine.getFindInCharSequence(textArea, start, forward);
        if (findIn2 == null) {
            return new SearchResult();
        }
        int markAllCount = 0;
        if (context.getMarkAll()) {
            markAllCount = SearchEngine.markAllImpl(textArea, context).getMarkedCount();
        }
        RegExReplaceInfo info2 = SearchEngine.getRegExReplaceInfo(findIn2, context);
        DocumentRange range2 = null;
        if (info2 != null) {
            c.setSelectionVisible(true);
            int matchStart = info2.getStartIndex();
            int matchEnd = info2.getEndIndex();
            if (forward) {
                matchStart += start;
                matchEnd += start;
            }
            textArea.setSelectionStart(matchStart);
            textArea.setSelectionEnd(matchEnd);
            String replacement = info2.getReplacement();
            textArea.replaceSelection(replacement);
            int dot = matchStart + replacement.length();
            findIn2 = SearchEngine.getFindInCharSequence(textArea, dot, forward);
            info2 = SearchEngine.getRegExReplaceInfo(findIn2, context);
            if (info2 != null) {
                matchStart = info2.getStartIndex();
                matchEnd = info2.getEndIndex();
                if (forward) {
                    matchStart += dot;
                    matchEnd += dot;
                }
                range2 = new DocumentRange(matchStart, matchEnd);
            } else {
                range2 = new DocumentRange(dot, dot);
            }
            SearchEngine.selectAndPossiblyCenter(textArea, range2, true);
        }
        int count2 = range2 != null ? 1 : 0;
        return new SearchResult(range2, count2, markAllCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchResult replace(RTextArea textArea, SearchContext context) throws PatternSyntaxException {
        String toFind;
        if (context.getMarkAll()) {
            textArea.clearMarkAllHighlights();
        }
        if ((toFind = context.getSearchFor()) == null || toFind.length() == 0) {
            return new SearchResult();
        }
        textArea.beginAtomicEdit();
        try {
            if (context.isRegularExpression()) {
                SearchResult searchResult = SearchEngine.regexReplace(textArea, context);
                return searchResult;
            }
            SearchEngine.makeMarkAndDotEqual(textArea, context.getSearchForward());
            SearchResult res = SearchEngine.find(textArea, context);
            if (res.wasFound() && !res.getMatchRange().isZeroLength()) {
                String replacement = context.getReplaceWith();
                textArea.replaceSelection(replacement);
                int dot = res.getMatchRange().getStartOffset();
                if (context.getSearchForward()) {
                    int length = replacement == null ? 0 : replacement.length();
                    dot += length;
                }
                textArea.setCaretPosition(dot);
                SearchResult next2 = SearchEngine.find(textArea, context);
                DocumentRange range2 = next2.wasFound() ? next2.getMatchRange() : new DocumentRange(dot, dot);
                res.setMatchRange(range2);
                SearchEngine.selectAndPossiblyCenter(textArea, range2, true);
            }
            SearchResult searchResult = res;
            return searchResult;
        }
        finally {
            textArea.endAtomicEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchResult replaceAll(RTextArea textArea, SearchContext context) throws PatternSyntaxException {
        if (context.getMarkAll()) {
            textArea.clearMarkAllHighlights();
        }
        context.setSearchForward(true);
        String toFind = context.getSearchFor();
        if (toFind == null || toFind.length() == 0) {
            return new SearchResult();
        }
        if (context.getMarkAll()) {
            context = context.clone();
            context.setMarkAll(false);
        }
        SearchResult lastFound = null;
        int count2 = 0;
        textArea.beginAtomicEdit();
        try {
            int oldOffs = textArea.getCaretPosition();
            textArea.setCaretPosition(0);
            SearchResult res = SearchEngine.replace(textArea, context);
            while (res.wasFound()) {
                lastFound = res;
                ++count2;
                res = SearchEngine.replace(textArea, context);
            }
            if (lastFound == null) {
                textArea.setCaretPosition(oldOffs);
                lastFound = new SearchResult();
            }
        }
        finally {
            textArea.endAtomicEdit();
        }
        lastFound.setCount(count2);
        return lastFound;
    }

    private static void selectAndPossiblyCenter(JTextArea textArea, DocumentRange range2, boolean select) {
        RSyntaxTextArea rsta;
        FoldManager fm;
        int start = range2.getStartOffset();
        int end = range2.getEndOffset();
        boolean foldsExpanded = false;
        if (textArea instanceof RSyntaxTextArea && (fm = (rsta = (RSyntaxTextArea)textArea).getFoldManager()).isCodeFoldingSupportedAndEnabled()) {
            foldsExpanded = fm.ensureOffsetNotInClosedFold(start);
            foldsExpanded |= fm.ensureOffsetNotInClosedFold(end);
        }
        if (select) {
            textArea.setSelectionStart(start);
            textArea.setSelectionEnd(end);
        }
        Rectangle r = null;
        try {
            r = textArea.modelToView(start);
            if (r == null) {
                return;
            }
            if (end != start) {
                r = r.union(textArea.modelToView(end));
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        Rectangle visible = textArea.getVisibleRect();
        if (!foldsExpanded && visible.contains(r)) {
            if (select) {
                textArea.setSelectionStart(start);
                textArea.setSelectionEnd(end);
            }
            return;
        }
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = textArea.getBounds();
        Insets i = textArea.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        textArea.scrollRectToVisible(visible);
    }
}

